unit fROR_UserDefined;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fROR_GenericRegistry, Menus, ActnList, ImgList, StdCtrls,
  ComCtrls, ExtCtrls, Buttons, ToolWin, fROR_VistARegistries, uROR_ListView,
  ovcbase, ovcfiler, ovcstore, uROR_VistAStore, uROR_Selector,
  uROR_CustomControls, uROR_CustomListView, uROR_GridView, HTMLLite,
  AdvMenus, uROR_SearchEdit, ovcstate, uROR_Errors, AdvMenuStylers,
  VA508AccessibilityManager;

type
  TFormUserDefined = class(TFormGenericRegistry)

    mnuPatients: TAdvPopupMenu;
    Edit1: TMenuItem;
    N4: TMenuItem;
    Delete1: TMenuItem;
    OvcComponentState: TOvcComponentState;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure acEditPatientDataExecute(Sender: TObject);
    procedure lsvPatientListKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure acHelpTopicsExecute(Sender: TObject);

  protected

    function  GetLayoutSectionName: String; override;

  public

    constructor CreateRegistry(aRegInfo: TRegistryInfo; anOwner: TComponent = nil); override;

  end;

implementation
{$R *.dfm}

uses
  fROR_PatientEdit, uROR_UDPatientData, uROR_Common, uROR_Broker, fROR_Main;

var
  FormPatientEdit: TFormPatientEdit;

constructor TFormUserDefined.CreateRegistry(aRegInfo: TRegistryInfo; anOwner: TComponent);
begin
  inherited CreateRegistry(aRegInfo, anOwner);

  if Assigned(RegInfo) then
    begin
      ActivePatientData := TUDPatientData.Create(aRegInfo.IEN);
      mnuHelpAbout.Hint := 'About|About the ' + RegInfo.Description;
      LoadLayout;
    end;
end;

procedure TFormUserDefined.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SaveLayout;
  inherited;
end;

function TFormUserDefined.GetLayoutSectionName: String;
begin
  if Assigned(OvcComponentState) then
    Result := OvcComponentState.Section
  else
    Result := inherited GetLayoutSectionName;
end;

/////////////////////////////////// Registry \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFormUserDefined.acEditPatientDataExecute(Sender: TObject);
var
  edRC: TReturnCode;
begin
  edRC := RC_OK;
  if not Assigned(FormPatientEdit) then
    FormPatientEdit := TFormPatientEdit.Create(RegInfo);
  if SetPatientContext then
    begin
      StartPatientEdit;
      try
        edRC := FormPatientEdit.Edit(ActivePatientData, PtIEN);
        inherited;
      finally
        EndPatientEdit;
      end;
    end;
  if edRC = RC_DELETE then
    acDeletePatient.Execute;
end;

procedure TFormUserDefined.acHelpTopicsExecute(Sender: TObject);
begin
  inherited;
  Application.HelpCommand(HELP_INDEX, 0);
end;

procedure TFormUserDefined.lsvPatientListKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  inherited;
  if Key = VK_Return then
    acEditPatientData.Execute;
end;

end.
